<?php defined('SYSPATH') or die('No direct script access.');

class Task_Parser_Referrer_Search extends Minion_Task{

	private $limit = 100000; // tmp because - easy

    protected function _execute(array $params){
	    $sphinxql = new SphinxQL();
	    $data = $sphinxql->new_query()
		    ->add_index('logpost')
		    ->search('@link *(citi com)*')
		    ->limit($this->limit)
		    ->executeOrFail();
	    $ids = [];
	    foreach($data['data'] as $d){
		    $ids[]  = $d['id'];
	    }
	    $result = DB::select('id','referrer')
		    ->from('logpost')
		    ->where('id', 'IN', $ids)
	        ->where('data', 'ILIKE', '%username_%')
		    ->execute()
		    ->as_array(NULL, 'referrer');

	    $new_result = array_unique($result);
	    $file_name = Text::random(null, 15);

	    foreach($new_result as $r){
		    file_put_contents('/root/'.$file_name.'.txt', $r."\n", FILE_APPEND);
	    }

	    Minion_CLI::write('FILENAME: '.$file_name);
    }
}